# Writing a Guide for this Website

This guide covers writing your own guide. After reading it, you should be able to:

* Format a guide.
* Submit it for approval and inclusion on this website.

## Format the guide

The best way for you to learn how to create a guide is to look at how a guide is structured. We are currently using the docrails project and as such all of the guides are written in textile.

A good example of how a guide can be structured is the 'Getting Started With Refinery' guide which you can [see
here](https://raw.github.com/refinery/refinerycms/master/doc/guides/1%20-%20Getting%20Started/2%20-%20Getting%20Started.md).

You should be able to match the sections of the raw textile guide with the [live guide](/guides/getting-started/) to see how each aspect works.

## Submitting the guide

* Login to <https://github.com>
* Go to <https://github.com/refinery/refinerycms>
* If you have a fork of refinerycms already, delete it (*if you're not going to lose work. This makes it much easier for us to integrate your changes back in*)
* Click on "fork" to make a fresh new fork on your own account.
* Clone your new fork to your local machine

Next make your changes or new guide in the `doc/guides` folder.

Now go to <https://github.com/refinery/refinerycms> and click "Pull Request".

After we review it, we'll merge it into the master refinerycms repository, and the changes will be up [Refinery CMS Guides](https://www.refinerycms.com/guides) within a few seconds.

## Why submit a guide?

The majority of Refinery CMS remains undocumented as development happens quickly. We'd appreciate it very much if you submitted a new guide or updated old ones. Here are some reasons for doing so:

* You will be listed as a contributor at [github](https://github.com/refinery/refinerycms/contributors)
* Help others who face the same issues
* Reduce the amount of time the core team spends on support so they can focus on making Refinery even better
